#!/bin/bash

# --- Variáveis de Configuração ---
APP_NAME="smart_terminal_flutter"
DESKTOP_FILE="${APP_NAME}.desktop"

# 1. Define o diretório de instalação (Exemplo: ~/Aplicativos)
INSTALL_DIR="$HOME/Aplicativos/$APP_NAME"
# Diretório onde o sistema procura por lançadores
LAUNCHER_DIR="$HOME/.local/share/applications"

echo "Iniciando a instalação do $APP_NAME..."

# --- 2. Copia o Bundle para o Diretório de Instalação ---

echo "Copiando arquivos para $INSTALL_DIR"
# Cria o diretório (recursivo)
mkdir -p "$INSTALL_DIR"

# Copia o conteúdo da pasta atual (o bundle) para o destino
cp -r * "$INSTALL_DIR/"

# Garante que o executável tenha permissão de execução
chmod +x "$INSTALL_DIR/$APP_NAME"

# --- 3. Instala o Arquivo .desktop no Lançador do Sistema ---

echo "Configurando o lançador de aplicativos..."

# Atualiza o campo Exec e Icon no .desktop com o caminho ABSOLUTO de instalação.
# Isso é crucial, pois o lançador precisa do caminho completo.
sed -i "s|Exec=.*|Exec=$INSTALL_DIR/$APP_NAME|g" "$INSTALL_DIR/$DESKTOP_FILE"

ICON_PATH="data/flutter_assets/assets/images/logo_lois.png"
sed -i "s|Icon=.*|Icon=$INSTALL_DIR/$ICON_PATH|g" "$INSTALL_DIR/$DESKTOP_FILE"


# Copia o lançador configurado para o diretório de aplicativos
mkdir -p "$LAUNCHER_DIR"
cp "$INSTALL_DIR/$DESKTOP_FILE" "$LAUNCHER_DIR/"
chmod +x "$LAUNCHER_DIR/$DESKTOP_FILE"

echo "Instalação concluída! Procure por '$APP_NAME' no seu menu de aplicativos."
echo "Para desinstalar, remova a pasta $INSTALL_DIR e o arquivo $LAUNCHER_DIR/$DESKTOP_FILE."